﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.Forms;

namespace SMS
{
    public partial class Form1 : Form
    {
        string numerTelefonuAdresata;
        bool zamknijPoWyslaniu = false;

        public Form1(string numerTelefonuAdresata)
        {
            InitializeComponent();

            this.numerTelefonuAdresata = numerTelefonuAdresata;
            sprawdzKontakt(numerTelefonuAdresata);
        }

        private void kontaktyButton_Click(object sender, EventArgs e)
        {
            ChooseContactDialog wybierzKontakt = new ChooseContactDialog();
            wybierzKontakt.RequiredProperties = new ContactProperty[] { ContactProperty.Sms };
            wybierzKontakt.Title = "Wybierz adresata";
            if (wybierzKontakt.ShowDialog() == DialogResult.OK)
            {
                numerTelefonuAdresata = wybierzKontakt.SelectedPropertyValue;
                adresatTextBox.Text = wybierzKontakt.SelectedContactName
                    + " <" + numerTelefonuAdresata + ">";
                wyslijMenuItem.Enabled = true;
            }
        }

        private void wyslijMenuItem_Click(object sender, EventArgs e)
        {
            SmsMessage sms = new SmsMessage(numerTelefonuAdresata, tekstTextBox.Text);
            sms.RequestDeliveryReport = potwierdzenieOdbioruMenuItem.Checked;
            try
            {
                sms.Send();
                MessageBox.Show("Wiadomość została wysłana!");
                if (zamknijPoWyslaniu) Close();
            }
            catch 
            { 
                MessageBox.Show("Nie udało się wysłać wiadomości!"); 
                return; 
            }            
        }

        private void potwierdzenieOdbioruMenuItem_Click(object sender, EventArgs e)
        {
            potwierdzenieOdbioruMenuItem.Checked = !potwierdzenieOdbioruMenuItem.Checked;
        }

        private void zakonczMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        public void sprawdzKontakt(string numerTelefonu)
        {
            if (numerTelefonu == null || numerTelefonu == "") return;

            OutlookSession outlook = new OutlookSession();
            var kontakty = from Contact kontakt in outlook.Contacts.Items
                                where kontakt.MobileTelephoneNumber==numerTelefonu
                                select kontakt.FirstName + " " + kontakt.LastName + " <" + kontakt.MobileTelephoneNumber + ">";
            if (kontakty.Count() == 0) adresatTextBox.Text = numerTelefonu;
            else adresatTextBox.Text = kontakty.First<string>();
            wyslijMenuItem.Enabled = true;
            zamknijPoWyslaniu = true;
        }
    }
}